--[[

    creative.lua
    ------------
    Defines the creative menu, listing creativity tools

--]]

local function generate_creative_menu_button(text, script, i)
    return {
        TYPE = "BUTTON",
        POSITION = string.format("(8 PIXELS, 8 PIXELS + %d TILES)", i),
        DIMENSIONS = "(9 TILESx 1 TILE)",
        TEXT = text,
        PRESS_SCRIPT = script
    }
end

CreateElement(
    "CREATIVE_MENU",
    "MENU OBJECT",
    {
        POSITION = "(180 SLICES - 5 TILES, 180 SLICES - 2 TILES - 8 PIXELS)",
        DIMENSIONS = "(10 TILES x 5 TILES)",
        MINTS = {
            SHELL_BUTTON =
                generate_creative_menu_button(
                    "Shell",
                    "LaunchMenu('SHELL_MENU')",
                    0),
            MAP_EDITOR_BUTTON =
                generate_creative_menu_button(
                    "Map Editor",
                    "LaunchMenu('CREATIVE_MENU_WIP', {featureName = 'Map Editor'})",
                    1),
            MENU_EDITOR_BUTTON =
                generate_creative_menu_button(
                    "Menu Editor",
                    "LaunchMenu('CREATIVE_MENU_WIP', {featureName = 'Menu Editor'})",
                    2),
            SOUNDBOARD_BUTTON =
                generate_creative_menu_button(
                    "Soundboard",
                    "LaunchMenu('CREATIVE_MENU_WIP', {featureName = 'Soundboard'})",
                    3)
        },
        APPEARANCE = {
            BORDER = {
                WIDTH = "1 PIXEL",
                ACTIVE_COLOR = "WHITE",
            },
        }
    }
)

CreateElement(
    "CREATIVE_MENU_WIP",
    "MENU OBJECT",
    {
        POSITION = "(180 SLICES - 5 TILES, 180 SLICES - 2 TILES - 8 PIXELS)",
        DIMENSIONS = "(10 TILES x 5 TILES)",
        MINTS = {
            TITLE = {
                TYPE = "LABEL",
                POSITION = "(8 PIXELS, 8 PIXELS)",
                DIMENSIONS = "(9 TILESx 1 TILE)",
                TEXT = "Sorry!",
            },
            PROMPT = {
                TYPE = "LABEL",
                POSITION = "(8 PIXELS, 1 TILE + 10 PIXELS)",
                DIMENSIONS = "(9 TILESx 2 TILES)",
            },
            BUTTON = {
                TYPE = "BUTTON",
                POSITION = "(1 TILE + 8 PIXELS, 3 TILES + 8 PIXELS)",
                DIMENSIONS = "(7 TILESx 1 TILE)",
                TEXT = "OK",
                PRESS_SCRIPT = "CloseSelf()"
            }
        },
        APPEARANCE = {
            BORDER = {
                WIDTH = "1 PIXEL",
                ACTIVE_COLOR = "WHITE",
            },
            MINTS = {
                TEXT = {
                    ALIGNMENT = "CENTER"
                }
            }
        },
        INIT_SCRIPT = function ()
            self.mints.PROMPT.text = string.format("%s is a\nwork in progress",
                                                   self.args.featureName)
        end
    }
)
