--[[

    main.lua
    --------
    Defines the main menu, which is the first menu to be launched,
    and the entry point for user interaction.

--]]

-- All menus already inherit any appearance information they are missing
--   from the main menu, but it's also useful to expose the palette as a
--   Lua global for consistency in additional appearance customization.

CommonPalette = {
    MenuBG = "(14,15,16)",
    SelectedMintBG = "(238,238,238)",
    Text = "(238,238,238)",
    SelectedText = "(14,15,16)",
    PrimaryColor = "(255,0,129)",
}

-- Local Helper Functions

local function generate_main_menu_button_mint(text, i, script)
    return {
        POSITION = string.format("(2 TILES, 360 SLICES - %d TILES)", 3 + (4 - i)),
        DIMENSIONS = "(6 TILES + 8 PIXELS x 1 TILE)",
        TEXT = text,
        TYPE = "BUTTON",
        PRESS_SCRIPT = script,
    }
end

-- Main Menu Definition

CreateElement(
    "MAIN_MENU",
    "MENU OBJECT",
    {
        "IS_FULLSCREEN",
        APPEARANCE = {
            BACKGROUND_COLOR = CommonPalette.MenuBG,
            MINTS = {
                ACTIVE_COLOR = CommonPalette.SelectedMintBG,
                TEXT = {
                    FONT = "ARCADE",
                    ACTIVE_COLOR = CommonPalette.SelectedText,
                    INACTIVE_COLOR = CommonPalette.Text,
                    ALIGNMENT = "LEFT",
                    MARGIN = "4 PIXELS",
                    WRAP = "WORDS",
                    LINE_HEIGHT = "10",
                    CURSOR = {
                        TYPE = "CHARACTER",
                        BLINK = "30 30"
                    }
                }
            }
        },
        MINTS = {
            HERO_MINT = {
                POSITION = "(0 PIXELS, 2 TILES)",
                DIMENSIONS = "(360 SLICES - 2 TILES x 2 TILES)",
                TEXT = string.format("%s", "MONOSPACE\nENGINE"),
                TYPE = "LABEL",
                APPEARANCE = {
                    TEXT = {
                        FONT = "BUBBLES",
                        INACTIVE_COLOR = CommonPalette.PrimaryColor,
                        ALIGNMENT = "RIGHT",
                        MARGIN = "0 PIXELS"
                    }
                }
            },
            VERSION_MINT = {
                POSITION = "(0 PIXELS, 4 TILES)",
                DIMENSIONS = "(360 SLICES - 2 TILES x 1 TILE)",
                TEXT = "v" .. ENGINE_VERSION,
                TYPE = "LABEL",
                APPEARANCE = {
                    TEXT = {
                        ALIGNMENT = "RIGHT",
                        FONT = "C64",
                        MARGIN = "0 PIXELS"
                    }
                }
            },
            NEW_GAME_MINT = generate_main_menu_button_mint("GAMES", 0,
                "LaunchMenu('GAMES_MENU')"),
            SETTINGS_MINT = generate_main_menu_button_mint("SETTINGS", 1,
                "LaunchMenu('SETTINGS_MENU')"),
            MAP_EDITOR_MINT = generate_main_menu_button_mint("CREATIVE", 2,
                "LaunchMenu('CREATIVE_MENU')"),
            ABOUT_MINT = generate_main_menu_button_mint("ABOUT", 3,
                "LaunchMenu('ABOUT_MENU')"),
            QUIT_MINT = generate_main_menu_button_mint("QUIT", 4,
                "CloseAll()")
        },
    }
)
